/*  Copyright 2025 Dieter Holzhäuser  E-Mail: dieter.holzhauser@gmail.com
  
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published serbuf
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

///////mtos  Serial User Input (SUI)    (call:  sr.initserinp(); )
 
//Format: (cmd (number) (number)) LF   
//         ~ equivalent   ( ) ~  optional,  
//cmd:    command string 1 to 6 characters
//number: # || 123 || -123 || 001234 || 1.23 || -1.23 (digits 1234 as example) 
//        # ~ no number (NONB)     001234 ~ time format hhmmss    
//        1.23 ~ intern 123    1.2 or 1.234 -> error  
//LF:     Enter     

//Principle: user inputs are transformed into activities by completing library task SUI
//within the application, see SER1

//Note the following short forms:   
//  WPIN  ~  digitalWrite       RPIN  ~  digitalRead
//  PR    ~  Serial.print       PRln  ~  Serial.println
//  OA    ~  nb[0]              OB    ~  nb[1]       (class Tnum data) 
//  IA    ~  sr.lnum[0]         IB    ~  sr.lnum[1]  (user input data)

#include <mtos.h>

///////Decomment the desired SER definition, only one allowed!!

//#define SER1    //User inputs and simple activities

#define SER2    //Some user inputs of task data and EEPROM storage.

//#define SER3   //System monitoring, base clock

//#define SER4   //Multi-Channel Timer, base clock

//#define SER5     //Staircase Lightning Timer

///////////Hardware Definitions
//      LED      Output pin
#define YELLOW   10
#define BLUE     11
#define GREEN    12
//LED_BUILTIN    13 
//               Input Pin
#define LBUTTON  17    //-> A3 
#define RBUTTON  18    //-> A4

///////////Task Definitions  ( 0 to 18)
#define TYELLOW        0  
#define TBLUE          1
#define TGREEN         2
#define LPUSH          3
#define RPUSH          4
#define GPCYCLE        5

/////////////Semaphore Definitions ( 0 to 18 ) 
#define GPSEMA         0       //General purpose semaphore

///////
void setup () {  
  pinMode  (YELLOW, OUTPUT);  
  pinMode  (BLUE, OUTPUT);  
  pinMode  (GREEN, OUTPUT); 
  pinMode  (LED_BUILTIN, OUTPUT); 
  pinMode  (LBUTTON, INPUT_PULLUP);   
  pinMode  (RBUTTON, INPUT_PULLUP); 
  os.initmt();            //init multitasking kernel  
  Serial.begin (38400);                      
  sr.initserinp();        //init serial user input              
  os.start (GPCYCLE, gpcycle1);
  os.runner ();                                             
}
//avoid loop() 