#ifdef SER1

//Simple (taskless) LED application can be controlled by user inputs

///////////Completion of library task SUI by application
//e.g.  "ye"      command string 
//e.g.  "--"      code of expected data inputs (i integer, f float, t hhmmss, - no input)
//e.g.  cmd_ye    assigned command function  (is a task function of task SUI,
//                                            task functions cannot be member of any class)
                          
const char ye [] PROGMEM = "ye -- YELLOW on/off";
const char gr [] PROGMEM = "gr -- GREEN on/off";
const char bl [] PROGMEM = "bl -- BLUE on/off";
struct cmdstruct cmds [] = { {ye, cmd_ye},
                             {gr, cmd_gr},  
                             {bl, cmd_bl}  };
char maxcmds = sizeof (cmds) / sizeof (cmdstruct) ;

//command functions
void cmd_ye () {          
  WPIN(YELLOW, !RPIN(YELLOW));
  prtstate (RPIN(YELLOW) );
  os.mtcoop (sui_clear);    //end of serial user input activity
} 
void cmd_gr () {           
  WPIN(GREEN, !RPIN(GREEN));  
  prtstate (RPIN(GREEN) );
  os.mtcoop (sui_clear);
} 
void cmd_bl () {          
  WPIN(BLUE, !RPIN(BLUE));
  prtstate (RPIN(BLUE) );
  os.mtcoop (sui_clear);
} 
void prtstate ( bool s) {
  if (s) PRln("on"); else PRln("off");
}

/////Task GPCYCLE        general purpose cycle
void gpcycle1 () {       //to add own and other inits    
  PR ("SER1 Hello, ");  
  mprint (LF_menu);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}

#endif