
/////////////Task REAC    reaction time measurement
//If RBUTTON is pressed, flashing LED BLUE switches OFF.
//A short time later LED BLUE switches ON. 
//Then user has to press RBUTTON as quickly as possible.
//Reaction time is displayed.

Tnum rc (0,0);               //time data

void reac1 () {     
  os.mtcoop (reac2);
}
void reac2 () {                //flashing LED by an embedded 100 ms cycle 
  WPIN(BLUE, !RPIN (BLUE) ); 
  os.mtdelay (100, reac2);               
  os.mtpin (RBUTTON, LOW, reac3);  //waitung for push 
}   
void reac3 () {           
  WPIN(BLUE,LOW ); 
  os.mtdelay ( 1500 + rand() % 4000 , reac4);   //random time 1,5 - 5,5 s
  os.mtpin ( RBUTTON, LOW, reac6);              //button pressed too early, process aborted
} 
void reac4 () {                   //start of measurement 
  WPIN(BLUE,HIGH );               //now user must react as quickly as possible  
  rc.OA = os.get_clock();           
  os.mtdelay ( 2000, reac6);         //button not pressed within 2 s, process aborted
  os.mtpin ( RBUTTON, LOW, reac5);    //waiting for pushbutton is pressed
}
void reac5 () {                    //stop of measurement
  rc.OB = os.get_clock() - rc.OA;  //calculate reaction time
  PR ("Reac time: " );
  PR (rc.OB );
  PRln (" ms");  
  WPIN (BLUE,LOW );  
  os.mtdelay (1500, reac2);           
}
void reac6 () {                    //no result
  PRln ( "too early or button not pressed");   
  os.mtcoop (reac2);        
}  

                  