/////////////Task PLAY      plays songs 
//Hardware: Speaker (about 1000 Ohms) connected to Nano pin 9
//Note data and note duration are saved in PROGMEM
//Timer1 converts note data into frequency.

#define TIMER1OFF  TCCR1B = TCCR1B & 0xF8;    //Prescaler = 0 means no tone
#define TIMER1ON   TCCR1B = TCCR1B | 1 << CS12 ;\
                   DDRB = DDRB | 1 << PB1;          
#define TIMER1INIT TCCR1A =  1<<COM1A0 ;\
                   TCCR1B =  TCCR1B | 1 << WGM12;\
                   TIMER1OFF 
#define TIMER1DEINIT TCCR1A = 0;\
                     TCCR1B = 0;            
#define TIMER1SET  TCNT1H = 0;\
                   TCNT1L = 0;
#define NOTE       OCR1A
 
//Note data   0 means rest
#define C   119
#define Cis 112
#define D   106
#define Dis 100
#define E   95
#define Fy  89   // Fy because F is indicated as redefined
#define Fis 84     
#define G   80      
#define Gis 75     
#define A   71      
#define Ais 67     
#define B   63      

//basic duration 
#define S18   5  // 1/8  
#define S14  10  // 1/4
#define S38  15  // 3/8
#define S12  20  // 1/2
#define S34  30  // 3/4
#define S11  40  // 1

#define PAUSE 30      //Pause after note to next note
 
//////////Notes and their duration (each line is one tact)
struct song { unsigned char note; unsigned char dur; } ;

const struct song radetzky [ ] PROGMEM  =  {
{0, 22 },              // ......[0].dur == 22 is tempo multiplicator
{G ,S14}, {G ,S14}, {G ,S14}, {0 , S14},
{B ,S14}, {A ,S14}, {G ,S14}, {0, S18}, {Fis, S18},

{E ,S18}, {Dis ,S18}, {E, S18}, {Fis ,S18}, {G ,S14}, {A, S14},
{D ,S12}, {0 ,S14}, {B ,S18}, {Ais, S18},
{B ,S14}, {B ,S18}, {Ais ,S18}, {B, S14}, {B, S18},{Ais ,S18},
{B ,S14}, {A ,S14}, {G ,S14}, {B, S18}, {Ais, S18},
{B ,S14}, {B ,S18}, {Ais ,S18}, {B, S14}, {B, S18},{Ais ,S18},
{B ,S14}, {E/2 ,S14}, {D/2 ,S14}, {D/2, S18}, {B, S18},

{C/2 ,S14}, {E/2 ,S14}, {D/2 ,S14}, {D/2, S18}, {A, S18},
{B ,S14}, {E/2 ,S14}, {D/2 ,S14}, {D/2, S18}, {B, S18},
{A ,S14}, {Fis/2 ,S12}, {E/2 ,S14},
{D/2, S14}, {D/2, S18}, {Cis/2, S18}, {D/2, S18}, {E/2, S18}, {D/2, S18}, {C/2, S18},
{B ,S14}, {B ,S18}, {Ais ,S18}, {B, S14}, {B, S18},{Ais ,S18},
{B ,S14}, {A ,S14}, {G ,S14}, {B, S18}, {Ais, S18},

{B,S14}, {B,S18}, {Ais ,S18}, {B, S14}, {B, S18}, {Ais, S18},
{B,S14}, {E/2 ,S14}, {D/2 ,S14}, {D/2, S18}, {B, S18},
{Cis/2 ,S14}, {B/2 ,S14}, {A/2 ,S14}, {0 ,S14},
{B, S14}, {A/2, S14}, {G/2, S14},  {0, S14},
{Fis/2 ,S14}, {0 ,S18}, {E/2 ,S18}, {D/2, S18}, {C/2, S18},{B, S18},{A ,S18},
{G ,S14}, {G/2 ,S14}, {G/2 ,S14}, {0, S14},
{0, 0}                           //...[].dur == 0   means end of song
};

const struct song auralee [ ] PROGMEM =  {
{0, 50 },
{C ,S14}, {Fy ,S14}, {E ,S14}, {Fy , S14},
{G ,S14}, {D ,S14}, {G ,S12},

{Fy ,S14}, {E ,S14}, {D ,S14}, {E , S14},
{Fy ,S11},
{C ,S14}, {Fy ,S14}, {E, S14}, {Fy, S14},
{G ,S14}, {D ,S14}, {G, S12},
{Fy ,S14}, {E ,S14}, {D ,S14}, {E , S14},
{Fy ,S11},

{A ,S38}, {A ,S18}, {A ,S12},
{A ,S38}, {A ,S18}, {A ,S12},
{A ,S14}, {G ,S14}, {Fy ,S14}, {G , S14},
{A ,S11},
{A ,S14}, {A ,S14}, {Ais ,S14}, {A , S14},
{G ,S14}, {D ,S14}, {G ,S38}, {Fy , S18},

{Fy ,S14}, {E ,S14}, {A ,S38}, {G , S18},
{Fy ,S11},
{0 ,0}  };

const struct song santalucia  [ ] PROGMEM =   {
{0, 45 },
{G ,S14}, {G ,S38}, {C/2 ,S18},
{C/2 ,S18}, {B ,S18}, {B ,S14}, {0, S14},
{Fy, S14},  {Fy ,S38}, {A ,S18},
{A, S14}, {G ,S14}, {0 ,S14},
{E, S14}, {A ,S38}, {G ,S18},
{G ,S18}, {Fis, S18},{Fy ,S14}, {0 ,S14},
{Fy, S14}, {E, S14}, {D, S14},
{A ,S14}, {G ,S14}, {0 ,S14},

{E/2 ,S14}, {D/2 ,S14}, {C/2 ,S14},
{B, S18}, {A, S18}, {D/2 ,S14}, {0 ,S14},
{D/2 ,S14}, {C/2 ,S14}, {A ,S14},
{Fis ,S18}, {G ,S18}, {C/2 ,S14}, {0 ,S14},
{E/2 ,S18}, {C/2 ,S18}, {C/2 ,S18}, {G ,S18}, {G ,S18}, {E ,S18},
{Fy ,S18}, {D/2 ,S18}, {D/2 ,S12},
{D/2 ,S14}, {A ,S38}, {B , S18},

{D/2 ,S14}, {C/2 ,S14}, {0 ,S14},
{0 ,0}  };

class Song {      //no constructor
public:
  int inote;      //counter
  int tempo;
  const struct song * psong ;
  void playstop ();
};
Song sg;

void Song::playstop () {       
  TIMER1DEINIT
   os.stop (PLAY,0);
}

/////////////Task PLAY
void play1 (void) {             //init task                 
  TIMER1INIT      
  sg.tempo = pgm_read_byte_near ( &sg.psong[0].dur);   
  sg.inote = 1;                             
  os.mtcoop (play2);
}

void play2 (void) {                 //play next note or rest 
  unsigned char note = pgm_read_byte_near (&sg.psong [sg.inote].note);  //get note data
  unsigned char dur = pgm_read_byte_near (&sg.psong [sg.inote].dur);    //get note basic duration
  if (dur == 0) {         //end of song
     TIMER1DEINIT         //no mt function ->  end of task        
  }
  else if ( note ) {                 // note > 0  tone, note == 0 rest)
              TIMER1SET             
              NOTE = note;             
              TIMER1ON               //Tone ON  
              os.mtdelay (sg.tempo * dur, play3);         
       }
       else os.mtdelay (PAUSE + sg.tempo * dur, play2);      //rest  
  sg.inote++;           
}

void play3 (void) {         //PAUSE 
  TIMER1OFF                 //Tone OFF
  os.mtdelay (PAUSE, play2);            
}
 