#ifdef ELEM9

//Three tasks want to signale a push of LBUTTON by LED flash (like ELEM8), but there is
//no restriction. Solution: All the tasks are waiting for pin event by LBUTTON and
//there are three flashes at the same time

//////////////////Task TYELLOW    single flash triggered by semaphore
void tyellow1 () {
  WPIN(YELLOW, LOW) ;  
  os.mtpin (LBUTTON, LOW, tyellow2 );
}
void tyellow2 () {
  WPIN(YELLOW, HIGH);  
  os.mtdelay (100, tyellow1); 
}

//////////////////Task TGREEN     dto.
void tgreen1 () {
  WPIN(GREEN, LOW) ;  
  os.mtpin (LBUTTON, LOW, tgreen2 );
}
void tgreen2 () {
  WPIN(GREEN, HIGH);  
  os.mtdelay (100, tgreen1); 
}

////////////////Task TBLUE        dto.
void tblue1 () {
  WPIN(BLUE, LOW) ;  
  os.mtpin (LBUTTON, LOW, tblue2 );
}
void tblue2 () {
  WPIN(BLUE, HIGH);  
  os.mtdelay (100, tblue1); 
}

/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits   
  os.start (TBLUE, tblue1);
  os.start (TYELLOW, tyellow1);
  os.start (TGREEN, tgreen1);
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}
#endif    
