#ifdef ELEM7

//Single flash of LED BLUE can be triggered by LBUTTON and by RBUTTON, use of finite task 
//Finite task is not part of calling task, in contrast to a subtask. 
//Mutual exclusion by semaphore is needed

Tnum bl (0,0);     //Tnum object saves flash duration

///////Finite Task TBLUE creates a single flash of LED BLUE
void tblue1 () {
  WPIN(BLUE , HIGH ) ;  
  os.mtdelay (bl.OA, tblue2); 
}
void tblue2 () {
  WPIN(BLUE , LOW ) ;  
  os.mtdelay (300, tblue3);
}
void tblue3 () {
  os.signal (GPSEMA);     //end of exclusion
}                         //no os.mt function call -> task stops -> finite task

/////////////////Task LPUSH    
void lpush1 () {               
  os.mtpin (LBUTTON, LOW, lpush2);   //wait for pushbutton is pressed
}
void lpush2 () {    
  os.mtsema (GPSEMA, lpush3);        //if applicable, wait for end of exclusion
}
void lpush3 () {
  bl.OA = 800;
  os.start (TBLUE, tblue1);       //flash 800 ms
  os.mtcoop (lpush1);
}

/////////////////Task RPUSH    
void rpush1 () {               
  os.mtpin (RBUTTON, LOW, rpush2);   //wait for pushbutton is pressed
}
void rpush2 () {    
  os.mtsema (GPSEMA, rpush3);        //if applicable, wait for end of exclusion 
}
void rpush3 () {
  bl.OA = 3000;
  os.start (TBLUE, tblue1);       //flash 3000 ms
  os.mtcoop (rpush1);
}
 
/////Task GPCYCLE        //general purpose cycle
void gpcycle1 () {       //to add own and other inits   
  os.signal (GPSEMA);    //init excl sema   
  os.start (LPUSH, lpush1);
  os.start (RPUSH, rpush1);        
  os.mtcoop (gpcycle2);
}

void gpcycle2 () {      //Task function as endless loop -> 1000 ms cycle     
  WPIN(LED_BUILTIN, !RPIN(LED_BUILTIN));    //toggled LED as sign of life, 
  os.mtdelay (1000, gpcycle2);  
}
#endif   